#--------------------------------------------------------
#	Script PiXYZ STUDIO - Create CAD Plane
#
#	This Python script is meant to be used in PiXYZ STUDIO 2018
#	Open the script in STUDIO Script window, and click the Execute button (CTRL+E)
#
#	This sample script shows how to create a BRep primitive plane in STUDIO using API mathematical functions
#
#	Copyright PiXYZ Software - 2018
#--------------------------------------------------------

def createPlaneFace(position, size):
	# create the carrier surface
	plane = cad.createPlaneSurface([[1, 0, 0, position[0]],[0, 1, 0, position[1]],[0, 0, 1, position[2]],[0, 0, 0, 1]])
	# create trim curves
	curve1 = cad.createSurfacicCurve(plane, cad.createSegmentCurve([0,0,0], [size,0,0]))
	curve2 = cad.createSurfacicCurve(plane, cad.createSegmentCurve([size,0,0], [size,size,0]))
	curve3 = cad.createSurfacicCurve(plane, cad.createSegmentCurve([size,size,0], [0,size,0]))
	curve4 = cad.createSurfacicCurve(plane, cad.createSegmentCurve([0,size,0], [0,0,0]))
	# create edges
	edge1 = cad.createEdge(curve1)
	edge2 = cad.createEdge(curve2)
	edge3 = cad.createEdge(curve3)
	edge4 = cad.createEdge(curve4)
	# create the loop
	loop = cad.createLoop([edge1, edge2, edge3, edge4], [True, True, True, True])
	# create the face (trimmedPlane)
	return cad.createFace(plane, [loop])
	
	
# create a new part with a BRep shape
part = scene.createPart("Plane")
scene.setParent(part, scene.getRoot())
shape = scene.createBRepShape(part)
model = scene.getBRepShapeModel(shape)

face = createPlaneFace([10, 50, 100], 100.)

cad.addToModel(face, model)

